#include "SGPhysique.h"
#include "SGentite.h"
#include <stdio.h>

SGPhysique *SGPhysique::s_pSGPhysique;

SGPhysique::SGPhysique(int iFrequence, float fVitesseMax)
: m_iFrequence(iFrequence)
{
    s_pSGPhysique=this;
    
    // verifie si la vitesse max donnee est positive
    if (fVitesseMax<0)
        m_fVitesseMax=-fVitesseMax;
    else
        m_fVitesseMax=fVitesseMax;
}

inline float SGPhysique::controleVitesse( float fV)
{
    if (fV<0.0 && fV< -m_fVitesseMax)
        return -m_fVitesseMax;
    else if ( fV>0.0 && fV > m_fVitesseMax)
        return m_fVitesseMax;
    else
        return fV;
}

void SGPhysique::restaurerCoordonnees(Entite *pEntite, int iDirection)
{
    if (pEntite->getPhysicData() != NULL)
    {
        if (iDirection==DROITE || iDirection==GAUCHE)
            pEntite->getPhysicData()->setX((float)pEntite->getX());
        if (iDirection==HAUT || iDirection==BAS)
            pEntite->getPhysicData()->setY((float)pEntite->getY());
    }
}

void SGPhysique::calculer()
{
    float fAx, fAy; // coordonnes de l'acceleration

    Entite *pEntite;
    PhysicData *pPd;
    
    if (g_SGEntite.getSizeListe()==0)
        return;
    
    g_SGEntite.debut();
    do
    {
        pEntite=g_SGEntite.getCourant();
        if (pEntite->getPhysicData()== NULL)
            continue;
            
        pPd=pEntite->getPhysicData();
        
        pPd->debloquer();
        
        if ((pPd->getVx(0)==0 && pPd->getVy(0)==0) && pPd->getSizeListe()==0)
            continue;
        
        
        //calcul des coordonnes de l'acceleration
        fAx = pPd->getSommeForcesX(0) / pPd->getMasse();
        fAy = pPd->getSommeForcesY(0) / pPd->getMasse();
            
        //calcul des coordonnes de la vitesse
        pPd->setVx( controleVitesse( pPd->getVx(0) + fAx ) );
        pPd->setVy( controleVitesse( pPd->getVy(0) + fAy ) );
       
        // calcul des coordonnes de l'element
        pPd->setX( 0.5 * fAx/ (float)m_iFrequence + pPd->getVx(0)/ (float)m_iFrequence  + pPd->getX());
        pPd->setY( 0.5 * fAy/ (float)m_iFrequence + pPd->getVy(0)/ (float)m_iFrequence  + pPd->getY() );
        
        pPd->enleverForces();
        
    } while (g_SGEntite.suivant());
}

inline void SGPhysique::replacer(PhysicData *pPd1, PhysicData *pPd2, int iDirection)
{ 
    switch (iDirection)
    {
        case HAUT : pPd1->setY(pPd2->getY()+(float)(pPd2->getY2()-pPd1->getY1())+1.0);
                    break;
        case BAS : pPd1->setY(pPd2->getY()+(float)(pPd2->getY1()-pPd1->getY2())-1.0);
                    break;
        case GAUCHE : pPd1->setX(pPd2->getX()+(float)(pPd2->getX2()-pPd1->getX1())+1.0);
                    break;
        case DROITE : pPd1->setX(pPd2->getX()+(float)(pPd2->getX1()-pPd1->getX2())-1.0);
    }
}

void SGPhysique::ajouterFrottement(PhysicData *pPd, int iDirection)
{
    switch (iDirection)
    {
        case HAUT : 
        case BAS  : pPd->setVx(pPd->getVx(0)*(1.0-pPd->getFrot(iDirection)));
                    break;
        case GAUCHE : 
        case DROITE : pPd->setVy(pPd->getVy(0)*(1.0-pPd->getFrot(iDirection)));
    }
}


int SGPhysique::getCollision(PhysicData *pPd)
{
    Entite *pEntite1,*pEntite2;
    
    pEntite1= new Entite((int)pPd->getX(),(int)pPd->getY());
    pEntite1->setPhysicData(pPd);
    
    if (g_SGEntite.getSizeListe()==0)
    {
        delete pEntite1;
        return AUCUNE;
    }
    
    g_SGEntite.debut();
    do
    {
        pEntite2=g_SGEntite.getCourant();
        if (pEntite2->getPhysicData()==NULL)
            continue;
        
        if (testerCollisions1(pEntite1,pEntite2)!=AUCUNE)
        {
            int tc;
            tc=testerCollisions1(pEntite1,pEntite2);
            delete pEntite1;
            return (tc);
        }
            
        
    }while (g_SGEntite.suivant());
    
    delete pEntite1;
    return AUCUNE;
}

inline void SGPhysique::ajouterReaction(PhysicData *pPd, int iDirection)
{
    switch (iDirection)
    {
        case HAUT : pPd->ajouterForce(new Force(0,-pPd->getSommeForcesY(-1),1),NULL);
                    break;
        case BAS : pPd->ajouterForce(new Force(0,-pPd->getSommeForcesY(1),1),NULL);
                    break;
        case GAUCHE : pPd->ajouterForce(new Force(-pPd->getSommeForcesX(-1),0,1),NULL);
                    break;
        case DROITE : pPd->ajouterForce(new Force(-pPd->getSommeForcesX(1),0,1),NULL);
    }
}

// passe toutes le entites bougeables et rempli le tableau de blocage
void SGPhysique::traiterBlocages()
{
    Entite *pEntite1;
    Entite *pEntite2;
    PhysicData *pPd1;
    PhysicData *pPd2;
    int n;
    int tc;
    bool trouve=true;
    
    n=g_SGEntite.getSizeListe();
    
    if (n==0)
        return;
        
    // premier test avec les entites non bougeables
    for (int i=0; i< n ; i++)
    {
        pEntite1=g_SGEntite.get(i);
        pPd1=pEntite1->getPhysicData();
        
        // on selectionne que les entites qui bougent
        if (pPd1==NULL)
            continue;
        if (!pPd1->getCollision() || !pPd1->getBouge())
            continue;
                
        g_SGEntite.debut();
        do
        {
            pEntite2=g_SGEntite.getCourant();
            pPd2=pEntite2->getPhysicData();
            
            if (pEntite2==pEntite1 || pPd2==NULL)
                continue;
            if (pPd2->getBouge())
                continue;

            tc=testerCollisions2(pEntite1,pEntite2);
            
            if (tc!=AUCUNE && !pPd1->getBloque(tc))
            {
                // verifie que l'on ne bloque pas une entite en train de rebondir
                if ( pPd1->getRebond(tc)>0.0 && !pPd1->arrete(tc))
                    continue;
                
           
                pPd1->setBloque(tc,true);
                
                ajouterReaction(pPd1,tc);
                tc=testerCollisions1(pEntite1,pEntite2);
                arreter(pPd1,tc);
                    
                if ( tc != AUCUNE )
                    replacer(pPd1,pPd2,tc);
                
                
            }
                        
        } while(g_SGEntite.suivant());
        
    }
    
    // deuxieme test qui bloque toutes les autres entites bloques par les prcedentes
    while(trouve)
    {
        trouve=false;
        for (int i=0; i< n ; i++)
        {
            pEntite1=g_SGEntite.get(i);
            pPd1=pEntite1->getPhysicData();
        
            if (pPd1==NULL)
                continue;
            if (!pPd1->getCollision() || !pPd1->getBouge())
                continue;
                
            g_SGEntite.debut();
            do
            {
                pEntite2=g_SGEntite.getCourant();
                pPd2=pEntite2->getPhysicData();
            
                if (pEntite2==pEntite1 || pPd2==NULL)
                    continue;
                if (!pPd2->getBouge() || !pPd2->getCollision() || !pPd2->getBloque())
                    continue;
                
                tc=testerCollisions2(pEntite1,pEntite2);
            
            
                if (tc!=AUCUNE && !pPd1->getBloque(tc) && pPd2->getBloque(tc) )
                {
                    // verifie que l'on ne bloque pas une entite en train de rebondir
                    if ( pPd1->getRebond(tc)>0.0 && !pPd1->arrete(tc))
                        continue;
                        
                    pPd1->setBloque(tc,true);
                    //pPd2->setBloque(inverse(tc),true);
                    trouve=true;
                    ajouterReaction(pPd1,tc);
                        
                    // rinitialise la vitesse et les coordonnes soulement
                    // si l'entitee est rentree dans l'autre et non pas qd 
                    // elle la touche simplement
                    tc=testerCollisions1(pEntite1,pEntite2);
                    arreter(pPd1,tc);
                    if ( tc != AUCUNE )
                        replacer(pPd1,pPd2,tc);
                    
                }

            } while(g_SGEntite.suivant());
        
        }
            
    }
    
}

void SGPhysique::traiterInteractions()
{
    Entite *pEntite1;
    Entite *pEntite2;
    PhysicData *pPd1;
    PhysicData *pPd2;
    int n;
    int tc;
    float fi;//force d'interaction
    bool trouve=true;
    
    n=g_SGEntite.getSizeListe();
    
    if (n==0)
        return;
    
    // premier passage qui traite le interactions mais ne replace pas
    for (int i=0; i< n ; i++)
    {
        pEntite1=g_SGEntite.get(i);
        pPd1=pEntite1->getPhysicData();
        
       
        if (pPd1==NULL)
            continue;
         // on ne selectionne que les entites qui bougent et qui collisionnent
         if (!pPd1->getCollision() || !pPd1->getBouge())
            continue;
                    
        g_SGEntite.debut();
        do
        {
            pEntite2=g_SGEntite.getCourant();
            pPd2=pEntite2->getPhysicData();
            
            if (pEntite2==pEntite1 || pPd2==NULL)
                continue;
        
            if (!pPd2->getCollision())
                continue;
                            
            tc=testerCollisions2(pEntite1,pEntite2);
            
            if (tc==AUCUNE)
                continue;
                
            if (pPd1->getRebond(tc)>0.0 && !pPd1->arrete(tc))
            {// pPd1 rebondi si en collision interne
                if (testerCollisions1(pEntite1,pEntite2)!=AUCUNE)
                    ajouterRebond(pPd1,pPd2,tc);
            }
            else
            {// pPd1 se bloque
                arreter(pPd1,tc);
                if (! pPd1->getBloque(tc))
                {
                    
                    pPd1->setBloque(tc,true);
                }
            }
            ajouterFrottement(pPd1,tc);
            
            
            
        } while (g_SGEntite.suivant());
    }
    
    // deuxieme passage qui remet les coordonnees
    for (int i=0; i< n ; i++)
    {
        pEntite1=g_SGEntite.get(i);
        pPd1=pEntite1->getPhysicData();
        
       
        if (pPd1==NULL)
            continue;
         // on ne selectionne que les entites qui bougent et qui collisionnent
         if (!pPd1->getCollision() || !pPd1->getBouge())
            continue;
                    
        g_SGEntite.debut();
        do
        {
            pEntite2=g_SGEntite.getCourant();
            pPd2=pEntite2->getPhysicData();
            
            if (pEntite2==pEntite1 || pPd2==NULL)
                continue;
        
            if (!pPd2->getCollision())
                continue;
                            
            tc=testerCollisions1(pEntite1,pEntite2);
            
            if (tc==AUCUNE)
                continue;
            
            
            
            if (!pPd2->getBouge())
            {
                replacer(pPd1,pPd2,tc);
            }
            else
            {
                restaurerCoordonnees(pEntite1,tc);
            }
            /*else if (pPd1->getBloque(tc) && !pPd2->getBloque(tc))
            {
                replacer(pPd2,pPd1,inverse(tc));
            }
            else if (!pPd1->getBloque(tc) && pPd2->getBloque(tc))
            {
                replacer(pPd1,pPd2,tc);
            }
            else
            {   
                
                if (pPd1->arrete(tc))
                {
                    replacer(pPd2,pPd1,inverse(tc));
                }
                else
                {
                    restaurerCoordonnees(pEntite1);
                    //replacer(pPd1,pPd2,tc);
                }
            }*/
            
            
        } while (g_SGEntite.suivant());
    }
}

void SGPhysique::traiterCollisions()
{
    traiterBlocages();
    traiterInteractions();
}


// teste les collisions entrantes
int SGPhysique::testerCollisions1(Entite *pEntite1, Entite *pEntite2)
{
    int iE1X1,iE1Y1,iE1X2,iE1Y2; // coordonnes du rectangle de Entite1
    int iE2X1,iE2Y1,iE2X2,iE2Y2; // coordonnes du rectangle de Entite2
    int tc=INDEFINIE;
    
    if (pEntite1 == NULL || pEntite2 == NULL)
        return AUCUNE;
    
    
    iE1X1 = arrondi(pEntite1->getPhysicData()->getX())+ pEntite1->getPhysicData()->getX1();
    iE1Y1 = arrondi(pEntite1->getPhysicData()->getY())+ pEntite1->getPhysicData()->getY1();
    iE1X2 = arrondi(pEntite1->getPhysicData()->getX())+ pEntite1->getPhysicData()->getX2();
    iE1Y2 = arrondi(pEntite1->getPhysicData()->getY())+ pEntite1->getPhysicData()->getY2();
    
    iE2X1 = arrondi(pEntite2->getPhysicData()->getX())+ pEntite2->getPhysicData()->getX1();
    iE2Y1 = arrondi(pEntite2->getPhysicData()->getY())+ pEntite2->getPhysicData()->getY1();
    iE2X2 = arrondi(pEntite2->getPhysicData()->getX())+ pEntite2->getPhysicData()->getX2();
    iE2Y2 = arrondi(pEntite2->getPhysicData()->getY())+ pEntite2->getPhysicData()->getY2();

    if(iE1Y1>iE2Y2 || iE1Y2<iE2Y1 || iE1X1>iE2X2 || iE1X2<iE2X1)
        return AUCUNE;

    if (iE2Y2 <= iE1Y2 &&  iE2Y2 >= iE1Y1 && iE2Y1<iE1Y1 &&  iE2X2-iE1X1>iE2Y2-iE1Y1 && iE1X2-iE2X1 >iE2Y2-iE1Y1)
    {
        return HAUT;
    }
    if (iE2Y1 <= iE1Y2 &&  iE2Y1>= iE1Y1 && iE2Y2>iE1Y2 && iE2X2-iE1X1>iE1Y2-iE2Y1 && iE1X2-iE2X1 >iE1Y2-iE2Y1)
    {
        return BAS;
    }
    if (iE2X2>=iE1X1 && iE2X2<=iE1X2 && iE2X1<iE1X1 && iE2Y2-iE1Y1>iE2X2-iE1X1 && iE1Y2-iE2Y1 > iE2X2-iE1X1)
    {
        return GAUCHE;
    }
    if (iE2X1>=iE1X1 && iE2X1<=iE1X2 && iE2X2>iE1X2 && iE2Y2-iE1Y1>iE1X2-iE2X1 && iE1Y2-iE2Y1 > iE1X2-iE2X1)
    {
        return DROITE;
    }

    return tc;
}

//teste les collisions de surface
int SGPhysique::testerCollisions2(Entite *pEntite1, Entite *pEntite2)
{
    int iE1X1,iE1Y1,iE1X2,iE1Y2; // coordonnes du rectangle de Entite1
    int iE2X1,iE2Y1,iE2X2,iE2Y2; // coordonnes du rectangle de Entite2
    int tc=INDEFINIE;
    
    if (pEntite1 == NULL || pEntite2 == NULL)
        return AUCUNE;
    
    
    iE1X1 = arrondi(pEntite1->getPhysicData()->getX())+ pEntite1->getPhysicData()->getX1()-1;
    iE1Y1 = arrondi(pEntite1->getPhysicData()->getY())+ pEntite1->getPhysicData()->getY1()-1;
    iE1X2 = arrondi(pEntite1->getPhysicData()->getX())+ pEntite1->getPhysicData()->getX2()+1;
    iE1Y2 = arrondi(pEntite1->getPhysicData()->getY())+ pEntite1->getPhysicData()->getY2()+1;
    
    iE2X1 = arrondi(pEntite2->getPhysicData()->getX())+ pEntite2->getPhysicData()->getX1();
    iE2Y1 = arrondi(pEntite2->getPhysicData()->getY())+ pEntite2->getPhysicData()->getY1();
    iE2X2 = arrondi(pEntite2->getPhysicData()->getX())+ pEntite2->getPhysicData()->getX2();
    iE2Y2 = arrondi(pEntite2->getPhysicData()->getY())+ pEntite2->getPhysicData()->getY2();

    if(iE1Y1>iE2Y2 || iE1Y2<iE2Y1 || iE1X1>iE2X2 || iE1X2<iE2X1)
        return AUCUNE;

    if (iE2Y2 <= iE1Y2 &&  iE2Y2 >= iE1Y1 && iE2Y1<iE1Y1 &&  iE2X2-iE1X1>iE2Y2-iE1Y1 && iE1X2-iE2X1 >iE2Y2-iE1Y1)
    {
        return HAUT;
    }
    if (iE2Y1 <= iE1Y2 &&  iE2Y1>= iE1Y1 && iE2Y2>iE1Y2 && iE2X2-iE1X1>iE1Y2-iE2Y1 && iE1X2-iE2X1 >iE1Y2-iE2Y1)
    {
        return BAS;
    }
    if (iE2X2>=iE1X1 && iE2X2<=iE1X2 && iE2X1<iE1X1 && iE2Y2-iE1Y1>iE2X2-iE1X1 && iE1Y2-iE2Y1 > iE2X2-iE1X1)
    {
        return GAUCHE;
    }
    if (iE2X1>=iE1X1 && iE2X1<=iE1X2 && iE2X2>iE1X2 && iE2Y2-iE1Y1>iE1X2-iE2X1 && iE1Y2-iE2Y1 > iE1X2-iE2X1)
    {
        return DROITE;
    }

    return tc;
}

inline int SGPhysique::arrondi(float f)
{
    if (f-(float)((int)f)>=0.5)
        return (int)f+1;
    else
        return (int)f;
}

inline float SGPhysique::abs(float f)
{
    if (f<0)
        return -f;
    else
        return f;
}

void SGPhysique::ajouterRebond(PhysicData *pPd1, PhysicData *pPd2, int iDirection)
{
    switch (iDirection)
    {
        case HAUT :        
        case BAS :  
                    if ((pPd1->getVy(0)>=0.0 && pPd2->getVy(0)>=0.0) ||(pPd1->getVy(0)<0.0 && pPd2->getVy(0)<0.0))
                    {
                        if (abs(pPd1->getVy(0))>=abs(pPd2->getVy(0)))
                        {
                            ajouterReaction(pPd1,iDirection);
                            pPd1->setVy(-pPd1->getVy(0)*pPd1->getRebond(iDirection));
                        }
                        else
                            pPd1->setVy(pPd1->getVy(0)+(pPd2->getVy(0)-pPd1->getVy(0)));    
                    }
                    else
                    {
                        ajouterReaction(pPd1,iDirection);
                        pPd1->setVy(-pPd1->getVy(0)*pPd1->getRebond(iDirection));
                    }
                    break;
        case GAUCHE : 
        case DROITE :

                    if ((pPd1->getVx(0)>=0.0 && pPd2->getVx(0)>=0.0) ||(pPd1->getVx(0)<0.0 && pPd2->getVx(0)<0.0))
                    {
                        if (abs(pPd1->getVx(0))>=abs(pPd2->getVx(0)))
                        {
                            ajouterReaction(pPd1,iDirection);
                            pPd1->setVx(-pPd1->getVx(0)*pPd1->getRebond(iDirection));
                        }
                        else
                            pPd1->setVx(pPd1->getVx(0)+(pPd2->getVx(0)-pPd1->getVx(0)));    
                    }
                    else
                    {
                        ajouterReaction(pPd1,iDirection);
                        pPd1->setVx(-pPd1->getVx(0)*pPd1->getRebond(iDirection));
                    }
    }
}

void SGPhysique::arreter(PhysicData *pPd, int iDirection)
{
    switch (iDirection)
    {
        case HAUT : if (pPd->getVy(0)<0) pPd->setVy(0.0); break;     
        case BAS :   if (pPd->getVy(0)>0) pPd->setVy(0.0); break; 
        case GAUCHE : if (pPd->getVx(0)<0) pPd->setVx(0.0); break; 
        case DROITE : if (pPd->getVx(0)>0) pPd->setVx(0.0); break;
    }
}

void SGPhysique::majCoordonnees()
{
    if( g_SGEntite.getSizeListe()==0)
        return;
    
    Entite *pE;
    
    g_SGEntite.debut();
    do
    {
        pE=g_SGEntite.getCourant();
        if (pE->getPhysicData()==NULL)
            continue;
        
        pE->setX(arrondi(pE->getPhysicData()->getX()));
        pE->setY(arrondi(pE->getPhysicData()->getY()));
        
    } while (g_SGEntite.suivant());
}

inline int SGPhysique::inverse(int iDirection)
{
    switch (iDirection)
    {
        case HAUT: return BAS;
        case BAS : return HAUT;
        case GAUCHE : return DROITE;
        case DROITE : return GAUCHE;
        default : return AUCUNE;
    }
}

int SGPhysique::testerCollision(const int iX,const int iY)
{
    if( g_SGEntite.getSizeListe()==0)
        return 0 ;
    
    Entite *pE;

    g_SGEntite.debut();
    do
    {
        pE=g_SGEntite.getCourant();
        if ( pE->getPhysicData() == NULL )
            continue;
        
        if ( iX >= arrondi(pE->getPhysicData()->getX())+ pE->getPhysicData()->getX1()-1 )
             if ( iX <= arrondi(pE->getPhysicData()->getX())+ pE->getPhysicData()->getX2()+1 )
                  if ( iY >= arrondi(pE->getPhysicData()->getY())+ pE->getPhysicData()->getY1()-1 )
                       if ( iY <= arrondi(pE->getPhysicData()->getY())+ pE->getPhysicData()->getY2()+1 )
                            return g_SGEntite.getRang() ;
                       
    } while (g_SGEntite.suivant());

    return -1;
}

int SGPhysique::testerCollision(const int iX1,const int iY1,const int iX2,const int iY2)
{
    Entite *pEntite1,*pEntite2;
    
    pEntite1= new Entite(iX1,iY1);
    PhysicData *pPd = new PhysicData(iX1,iY1,0,0,iX2,iY2,0,false,true);
    pEntite1->setPhysicData(pPd);
    
    if ( g_SGEntite.getSizeListe()==0 )
    {
        delete pEntite1;
        return -1;
    }
    
    g_SGEntite.debut();
    do
    {
        pEntite2=g_SGEntite.getCourant();
        if (pEntite2->getPhysicData()==NULL)
            continue;
        
        if (testerCollisions1(pEntite1,pEntite2)!=AUCUNE)
        {
            delete pEntite1;
            return g_SGEntite.getRang();
        }
            
        
    }while (g_SGEntite.suivant());
    
    delete pEntite1;
    return -1;
}
